//AIM:To design Low pass Chebyshev filter and plot response.
//Software version Scilab 5.5.2
//OS Windows 7

clc;
clear;
//ripple
rp=6;//ripple in dB.
ohm=2;//ohm=normalized frequency.
IL=50;//IL is the insertion loss (in dB).
a=sqrt(10^(rp/10)-1)
//To optain order of filter N
// Using equation IL=10*log(1+a^2*(T^2(Ω)))
num=acosh(sqrt((10^(0.1*IL)-1)/(a^2)))
dem=acosh(ohm)
N=num/dem
x=N-int(N)
if(x>0);
    N=int(N)+1;
end
disp(N,"Order of filter=");
ohm=0:0.01:1;
T=cos(N*(acos(ohm)));
IL=10*log10(1+(T.^2).*a^2);
title('Response of low pass Chebychev filter');
ylabel("IL in dB");
xlabel("normalized frequency");
plot2d(ohm,IL);
ohm=0:0.1:1;
T=cos(N*(acos(ohm)));
IL=10*log10(1+(T.^2).*a^2);
disp(IL,"IL in dB",ohm,"normalized frequency");
